/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.entity.EntityPlayer;
import net.jayjay.dangerzone.phys.AABB;
import net.jayjay.dangerzone.phys.HitResult;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.world.Frustum;
import net.jayjay.dangerzone.world.IWorldListener;
import net.jayjay.dangerzone.world.World;
import net.jayjay.dangerzone.world.chunk.Chunk;
import net.jayjay.dangerzone.world.chunk.ChunkPos;
import net.jayjay.dangerzone.world.chunk.DirtyChunkSorter;
import org.lwjgl.opengl.GL11;

public class WorldRenderer
implements IWorldListener {
    public static final int MAX_REBUILDS_PER_FRAME = 8;
    private World world;
    private ConcurrentHashMap<ChunkPos, Chunk> renderChunks = new ConcurrentHashMap();

    public WorldRenderer(World level) {
        this.world = level;
        this.world.addListener(this);
    }

    private Chunk getRenderChunk(int chunkX, int chunkY, int chunkZ) {
        ChunkPos pos = new ChunkPos(chunkX, chunkY, chunkZ);
        return this.renderChunks.computeIfAbsent(pos, p -> {
            int x0 = chunkX * 16;
            int y0 = chunkY * 16;
            int z0 = chunkZ * 16;
            int x1 = x0 + 16;
            int y1 = y0 + 16;
            int z1 = z0 + 16;
            return new Chunk(this.world, x0, y0, z0, x1, y1, z1);
        });
    }

    public void updateVisibleChunks(EntityPlayer player) {
        int playerChunkX = (int)Math.floor(player.x / 16.0f);
        int playerChunkY = (int)Math.floor(player.y / 16.0f);
        int playerChunkZ = (int)Math.floor(player.z / 16.0f);
        int renderDistance = this.world.getRenderDistance() / 2;
        HashSet<ChunkPos> visibleChunks = new HashSet<ChunkPos>();
        int dx = -renderDistance;
        while (dx <= renderDistance) {
            int dy = -renderDistance;
            while (dy <= renderDistance) {
                int dz = -renderDistance;
                while (dz <= renderDistance) {
                    int chunkX = playerChunkX + dx;
                    int chunkY = playerChunkY + dy;
                    int chunkZ = playerChunkZ + dz;
                    ChunkPos pos = new ChunkPos(chunkX, chunkY, chunkZ);
                    visibleChunks.add(pos);
                    this.getRenderChunk(chunkX, chunkY, chunkZ);
                    ++dz;
                }
                ++dy;
            }
            ++dx;
        }
        Iterator<Map.Entry<ChunkPos, Chunk>> iter = this.renderChunks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ChunkPos, Chunk> entry = iter.next();
            if (visibleChunks.contains(entry.getKey())) continue;
            iter.remove();
        }
    }

    public List<Chunk> getAllDirtyChunks() {
        ArrayList<Chunk> dirty = null;
        for (Chunk chunk : this.renderChunks.values()) {
            if (!chunk.isDirty()) continue;
            if (dirty == null) {
                dirty = new ArrayList<Chunk>();
            }
            dirty.add(chunk);
        }
        return dirty;
    }

    public void render(EntityPlayer player, int layer) {
        GL11.glEnable(3553);
        Frustum frustum = Frustum.getFrustum();
        for (Chunk chunk : this.renderChunks.values()) {
            if (!frustum.isVisible(chunk.aabb)) continue;
            chunk.render(layer);
        }
        GL11.glDisable(3553);
    }

    public void updateDirtyChunks(EntityPlayer player) {
        this.updateVisibleChunks(player);
        List<Chunk> dirty = this.getAllDirtyChunks();
        if (dirty != null) {
            Collections.sort(dirty, new DirtyChunkSorter(player, Frustum.getFrustum()));
            int i2 = 0;
            while (i2 < 1 && i2 < dirty.size()) {
                dirty.get(i2).rebuild();
                ++i2;
            }
        }
    }

    public void pick(EntityPlayer player, Frustum frustum) {
        if (player.bb == null) {
            return;
        }
        Tesselator t = Tesselator.INSTANCE;
        float r = 3.0f;
        AABB box = player.bb.grow(r, r, r);
        int x0 = (int)box.x0;
        int x1 = (int)(box.x1 + 1.0f);
        int y0 = (int)box.y0;
        int y1 = (int)(box.y1 + 1.0f);
        int z0 = (int)box.z0;
        int z1 = (int)(box.z1 + 1.0f);
        GL11.glInitNames();
        GL11.glPushName(0);
        GL11.glPushName(0);
        int x = x0;
        while (x < x1) {
            GL11.glLoadName(x);
            GL11.glPushName(0);
            int y = y0;
            while (y < y1) {
                GL11.glLoadName(y);
                GL11.glPushName(0);
                int z = z0;
                while (z < z1) {
                    Block tile = Blocks.getBlockById(this.world.getBlock(x, y, z));
                    if (tile != null && tile != Blocks.air && frustum.isVisible(tile.getTileAABB(x, y, z))) {
                        GL11.glLoadName(z);
                        GL11.glPushName(0);
                        int i2 = 0;
                        while (i2 < 6) {
                            GL11.glLoadName(i2);
                            t.begin(7);
                            tile.renderFaceNoTexture(t, x, y, z, i2);
                            t.flush();
                            ++i2;
                        }
                        GL11.glPopName();
                    }
                    ++z;
                }
                GL11.glPopName();
                ++y;
            }
            GL11.glPopName();
            ++x;
        }
        GL11.glPopName();
        GL11.glPopName();
    }

    public void renderHit(HitResult h2) {
        Tesselator t = Tesselator.INSTANCE;
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 1);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, ((float)Math.sin((double)System.currentTimeMillis() / 100.0) * 0.2f + 0.9f) * 0.5f);
        t.begin(7);
        float x0 = (float)h2.x + 0.0f;
        float x1 = (float)h2.x + 1.0f;
        float y0 = (float)h2.y + 0.0f;
        float y1 = (float)h2.y + 1.0f;
        float z0 = (float)h2.z + 0.0f;
        float z1 = (float)h2.z + 1.0f;
        t.addVertex(x0, y0, z1);
        t.addVertex(x0, y0, z0);
        t.addVertex(x1, y0, z0);
        t.addVertex(x1, y0, z1);
        t.addVertex(x1, y1, z1);
        t.addVertex(x1, y1, z0);
        t.addVertex(x0, y1, z0);
        t.addVertex(x0, y1, z1);
        t.addVertex(x0, y1, z0);
        t.addVertex(x1, y1, z0);
        t.addVertex(x1, y0, z0);
        t.addVertex(x0, y0, z0);
        t.addVertex(x0, y1, z1);
        t.addVertex(x0, y0, z1);
        t.addVertex(x1, y0, z1);
        t.addVertex(x1, y1, z1);
        t.addVertex(x0, y1, z1);
        t.addVertex(x0, y1, z0);
        t.addVertex(x0, y0, z0);
        t.addVertex(x0, y0, z1);
        t.addVertex(x1, y0, z1);
        t.addVertex(x1, y0, z0);
        t.addVertex(x1, y1, z0);
        t.addVertex(x1, y1, z1);
        t.flush();
        GL11.glDisable(3042);
    }

    public void setDirty(int x0, int y0, int z0, int x1, int y1, int z1) {
        int chunkX0 = Math.floorDiv(x0, 16);
        int chunkX1 = Math.floorDiv(x1, 16);
        int chunkZ0 = Math.floorDiv(z0, 16);
        int chunkZ1 = Math.floorDiv(z1, 16);
        int chunkY0 = Math.floorDiv(y0, 16);
        int chunkY1 = Math.floorDiv(y1, 16);
        int cx = chunkX0;
        while (cx <= chunkX1) {
            int cy = chunkY0;
            while (cy <= chunkY1) {
                int cz = chunkZ0;
                while (cz <= chunkZ1) {
                    ChunkPos pos = new ChunkPos(cx, cy, cz);
                    Chunk chunk = this.renderChunks.get(pos);
                    if (chunk != null) {
                        chunk.setDirty();
                    } else {
                        chunk = this.getRenderChunk(cx, cy, cz);
                        chunk.setDirty();
                    }
                    ++cz;
                }
                ++cy;
            }
            ++cx;
        }
    }

    @Override
    public void tileChanged(int x, int y, int z) {
        this.setDirty(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1);
    }

    @Override
    public void lightColumnChanged(int x, int z, int y0, int y1) {
        this.setDirty(x - 1, y0 - 1, z - 1, x + 1, y1 + 1, z + 1);
    }

    @Override
    public void allChanged() {
        for (Chunk chunk : this.renderChunks.values()) {
            chunk.setDirty();
        }
    }
}

